/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.DelegatingMemoryIO;
import java.nio.charset.Charset;

public class BoundedMemoryIO
extends AbstractMemoryIO
implements DelegatingMemoryIO {
    private final long base;
    private final long size;
    private final MemoryIO io;

    public BoundedMemoryIO(MemoryIO memoryIO, long l, long l2) {
        this.io = memoryIO;
        this.base = l;
        this.size = l2;
    }

    public boolean isDirect() {
        return this.getDelegatedMemoryIO().isDirect();
    }

    public long address() {
        return this.getDelegatedMemoryIO().address();
    }

    public MemoryIO getDelegatedMemoryIO() {
        return this.io;
    }

    public byte getByte(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 1L);
        return this.io.getByte(this.base + l);
    }

    public short getShort(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 2L);
        return this.io.getShort(this.base + l);
    }

    public int getInt(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 4L);
        return this.io.getInt(this.base + l);
    }

    public long getLong(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 8L);
        return this.io.getLong(this.base + l);
    }

    public float getFloat(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 4L);
        return this.io.getFloat(this.base + l);
    }

    public double getDouble(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, 8L);
        return this.io.getDouble(this.base + l);
    }

    public Pointer getPointer(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, Address.SIZE / 8);
        return this.io.getPointer(this.base + l);
    }

    public MemoryIO getMemoryIO(long l) {
        BoundedMemoryIO.checkBounds(this.size, this.base + l, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + l);
    }

    public MemoryIO getMemoryIO(long l, long l2) {
        BoundedMemoryIO.checkBounds(this.size, this.base + l, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + l, l2);
    }

    public void putByte(long l, byte by) {
        BoundedMemoryIO.checkBounds(this.size, l, 1L);
        this.io.putByte(this.base + l, by);
    }

    public void putShort(long l, short s) {
        BoundedMemoryIO.checkBounds(this.size, l, 2L);
        this.io.putShort(this.base + l, s);
    }

    public void putInt(long l, int n) {
        BoundedMemoryIO.checkBounds(this.size, l, 4L);
        this.io.putInt(this.base + l, n);
    }

    public void putLong(long l, long l2) {
        BoundedMemoryIO.checkBounds(this.size, l, 8L);
        this.io.putLong(this.base + l, l2);
    }

    public void putFloat(long l, float f) {
        BoundedMemoryIO.checkBounds(this.size, l, 4L);
        this.io.putFloat(this.base + l, f);
    }

    public void putDouble(long l, double d) {
        BoundedMemoryIO.checkBounds(this.size, l, 8L);
        this.io.putDouble(this.base + l, d);
    }

    public void putPointer(long l, Pointer pointer) {
        BoundedMemoryIO.checkBounds(this.size, l, Address.SIZE / 8);
        this.io.putPointer(this.base + l, pointer);
    }

    public void get(long l, byte[] byArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2);
        this.io.get(this.base + l, byArray, n, n2);
    }

    public void put(long l, byte[] byArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2);
        this.io.put(this.base + l, byArray, n, n2);
    }

    public void get(long l, short[] sArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 16 / 8);
        this.io.get(this.base + l, sArray, n, n2);
    }

    public void put(long l, short[] sArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 16 / 8);
        this.io.put(this.base + l, sArray, n, n2);
    }

    public void get(long l, int[] nArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 32 / 8);
        this.io.get(this.base + l, nArray, n, n2);
    }

    public void put(long l, int[] nArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 32 / 8);
        this.io.put(this.base + l, nArray, n, n2);
    }

    public void get(long l, long[] lArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 64 / 8);
        this.io.get(this.base + l, lArray, n, n2);
    }

    public void put(long l, long[] lArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 64 / 8);
        this.io.put(this.base + l, lArray, n, n2);
    }

    public void get(long l, float[] fArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 32 / 8);
        this.io.get(this.base + l, fArray, n, n2);
    }

    public void put(long l, float[] fArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 32 / 8);
        this.io.put(this.base + l, fArray, n, n2);
    }

    public void get(long l, double[] dArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 64 / 8);
        this.io.get(this.base + l, dArray, n, n2);
    }

    public void put(long l, double[] dArray, int n, int n2) {
        BoundedMemoryIO.checkBounds(this.size, l, n2 * 64 / 8);
        this.io.put(this.base + l, dArray, n, n2);
    }

    public long getAddress(long l) {
        BoundedMemoryIO.checkBounds(this.size, l, Address.SIZE >> 3);
        return this.io.getAddress(this.base + l);
    }

    public String getString(long l, int n, Charset charset) {
        BoundedMemoryIO.checkBounds(this.size, l, n);
        return this.io.getString(this.base + l, n, charset);
    }

    public String getString(long l) {
        return this.io.getString(this.base + l, (int)this.size, Charset.defaultCharset());
    }

    public void putAddress(long l, long l2) {
        BoundedMemoryIO.checkBounds(this.size, l, Address.SIZE >> 3);
        this.io.putAddress(this.base + l, l2);
    }

    public void putAddress(long l, Address address) {
        BoundedMemoryIO.checkBounds(this.size, l, Address.SIZE >> 3);
        this.io.putAddress(this.base + l, address);
    }

    public void putString(long l, String string, int n, Charset charset) {
        BoundedMemoryIO.checkBounds(this.size, l, n);
        this.io.putString(this.base + l, string, n, charset);
    }

    public int indexOf(long l, byte by) {
        return this.io.indexOf(this.base + l, by, (int)this.size);
    }

    public int indexOf(long l, byte by, int n) {
        BoundedMemoryIO.checkBounds(this.size, l, n);
        return this.io.indexOf(this.base + l, by, n);
    }

    public void setMemory(long l, long l2, byte by) {
        BoundedMemoryIO.checkBounds(this.size, this.base + l, l2);
        this.io.setMemory(this.base + l, l2, by);
    }
}

